#!/bin/bash
DATASET="MMHal-Bench"
MODEL_PATH=$1
# MODEL_PATH="/models/Qwen/Qwen-VL-Chat"
if [ -z "$2" ]; then
    overwrite=False
else
    overwrite=$2
fi

pred_data=$(python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)

echo "pred_data: ${pred_data}"
# if len(pred_data) == 0, exist 1
if [ -z "${pred_data}" ]; then
    exit 1
else
    echo "File ${pred_data} exists."
fi


pip install openai==0.28

python llava/eval/eval_mmhal.py  run_mmhal_eval   \
      --gt_data /<DATA_FOLDER>/MMHal-Bench/response_template.llava_eval.jsonl \
      --pred_data ${pred_data}  
